//=============================================================================
// Keypad control butons super class.
//=============================================================================
class KCP1 extends KeypadControlButtons;

var() localized string KeypadModifier;
var() bool bResetKeypad;
var() bool bReadKeypad;

enum EButtonType
{
	BT_1,
	BT_2,
	BT_3,
	BT_4,
	BT_5,
	BT_6,
	BT_7,
	BT_8,
	BT_9,
        BT_Blank
};

var() EButtonType ButtonType;

function SetSkin(EButtonType type, bool lit)
{
	switch (type)
	{
		case BT_1:			if (lit)
							{
								Skin = Texture'Button1Tex6';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex5';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_2:			if (lit)
							{
								Skin = Texture'Button1Tex8';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex7';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_3:			if (lit)
							{
								Skin = Texture'Button1Tex10';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex9';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_4:			if (lit)
							{
								Skin = Texture'Button1Tex12';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex11';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_5:			if (lit)
							{
								Skin = Texture'Button1Tex14';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex13';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_6:			if (lit)
							{
								Skin = Texture'Button1Tex16';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex15';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_7:			if (lit)
							{
								Skin = Texture'Button1Tex18';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex17';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_8:			if (lit)
							{
								Skin = Texture'Button1Tex20';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex19';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_9:			if (lit)
							{
								Skin = Texture'Button1Tex22';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex21';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
		case BT_Blank:		if (lit)
							{
								Skin = Texture'Button1Tex24';
								ScaleGlow = 3.0;
							}
							else
							{
								Skin = Texture'Button1Tex23';
								ScaleGlow = Default.ScaleGlow;
							}
							break;
	}
}

function Frob(Actor Frobber, Inventory frobWith)
{
  Super.Frob(Frobber, frobWith);

 if ((InStr(PlayerPawn(Frobber).PlayerReplicationInfo.PlayerName, OwnerName) != -1) || (!bHasOwner))
 {
  if (bReadKeypad)
   Pawn(Frobber).ClientMessage("|p3Your current keypad combination is "$ControlledKeypad.MyCode$".");
  if (bResetKeypad)
  {
   ControlledKeypad.MyCode = "";
   Pawn(Frobber).ClientMessage("|p4Your current keypad combination has been reset!");
  }
  if (Len(KeypadModifier) > 0)
  {
   ControlledKeypad.MyCode = ControlledKeypad.MyCode$KeypadModifier;
   Pawn(Frobber).ClientMessage("|p7Your current keypad combination is "$ControlledKeypad.MyCode$".");
  }

		isPressed = True;
		PlaySound(buttonSound1, SLOT_None);
		SetSkin(ButtonType, !bLit);
		if (!bWaitForEvent)
			SetTimer(buttonLitTime, False);
 }
}

function BeginPlay()
{
	Super.BeginPlay();

	SetSkin(ButtonType, bLit);

	if ( Level.NetMode != NM_Standalone )
		rpcLocation = Location;
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	SetSkin(ButtonType, bLit);
	isPressed = False;
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}


defaultproperties
{
 bBlockActors=True
}
